/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.game;

import Krasnodar.rockstarnew.utility.game.server.ServerUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_266;
import net.minecraft.class_8646;
import net.minecraft.class_9013;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9025;
import net.minecraft.class_9362;

public final class EntityUtility
implements IMinecraft {
    private static float timer = 1.0f;

    public static void resetTimer() {
        timer = 1.0f;
    }

    public static class_2248 getBlock() {
        return EntityUtility.getBlock(0.0, 0.0, 0.0);
    }

    public static class_2248 getBlock(double x, double y, double z) {
        return !EntityUtility.isInGame() ? class_2246.field_10124 : EntityUtility.mc.field_1687.method_8320(class_2338.method_49638((class_2374)EntityUtility.mc.field_1724.method_19538().method_1031(x, y, z))).method_26204();
    }

    public static boolean collideWith(class_1309 entity) {
        return EntityUtility.collideWith(entity, 0.0f);
    }

    public static boolean collideWith(class_1309 entity, float grow) {
        class_238 box = EntityUtility.mc.field_1724.method_5829();
        class_238 targetbox = entity.method_5829().method_1009((double)grow, 0.0, (double)grow);
        return box.field_1320 > targetbox.field_1323 && box.field_1325 > targetbox.field_1322 && box.field_1324 > targetbox.field_1321 && box.field_1323 < targetbox.field_1320 && box.field_1322 < targetbox.field_1325 && box.field_1321 < targetbox.field_1324;
    }

    public static void setSpeed(double speed) {
        double forward = EntityUtility.mc.field_1724.field_3913.field_3905;
        double strafe = EntityUtility.mc.field_1724.field_3913.field_3907;
        float yaw = EntityUtility.mc.field_1724.method_36454();
        if (forward == 0.0 && strafe == 0.0) {
            EntityUtility.mc.field_1724.method_18800(0.0, EntityUtility.mc.field_1724.method_18798().field_1351, 0.0);
        } else {
            if (forward != 0.0) {
                if (strafe > 0.0) {
                    yaw += forward > 0.0 ? -45.0f : 45.0f;
                } else if (strafe < 0.0) {
                    yaw += forward > 0.0 ? 45.0f : -45.0f;
                }
                strafe = 0.0;
                forward = forward > 0.0 ? 1.0 : -1.0;
            }
            double motionX = forward * speed * Math.cos(Math.toRadians((double)yaw + 90.0)) + strafe * speed * Math.sin(Math.toRadians((double)yaw + 90.0));
            double motionZ = forward * speed * Math.sin(Math.toRadians((double)yaw + 90.0)) - strafe * speed * Math.cos(Math.toRadians((double)yaw + 90.0));
            EntityUtility.mc.field_1724.method_18800(motionX, EntityUtility.mc.field_1724.method_18798().field_1351, motionZ);
        }
    }

    public static boolean isPlayerMoving() {
        return EntityUtility.mc.field_1724 != null && EntityUtility.mc.field_1687 != null && EntityUtility.mc.field_1724.field_3913 != null ? (double)EntityUtility.mc.field_1724.field_6250 != 0.0 || (double)EntityUtility.mc.field_1724.field_3913.field_3907 != 0.0 : false;
    }

    public static class_2248 getBlockBelow(class_1297 entity) {
        if (entity == null) {
            return null;
        }
        class_2338 pos = entity.method_24515().method_10074();
        return EntityUtility.getBlockAt(pos, entity.method_37908());
    }

    public static class_2248 getBlockAbove(class_1297 entity) {
        if (entity == null) {
            return null;
        }
        class_2338 pos = entity.method_24515().method_10069(0, Math.round(entity.method_17682()), 0).method_10084();
        return EntityUtility.getBlockAt(pos, entity.method_37908());
    }

    public static class_2248 getBlockBelowPlayer() {
        if (EntityUtility.mc.field_1724 != null && EntityUtility.mc.field_1687 != null) {
            class_2338 pos = EntityUtility.mc.field_1724.method_24515().method_10074().method_10084();
            return EntityUtility.getBlockAt(pos, (class_1937)EntityUtility.mc.field_1687);
        }
        return null;
    }

    public static class_2248 getBlockAbovePlayer() {
        if (EntityUtility.mc.field_1724 != null && EntityUtility.mc.field_1687 != null) {
            class_2338 pos = EntityUtility.mc.field_1724.method_24515().method_10084();
            return EntityUtility.getBlockAt(pos, (class_1937)EntityUtility.mc.field_1687);
        }
        return null;
    }

    public static class_2248 getBlockStandingOn(class_1297 entity) {
        if (entity == null) {
            return null;
        }
        class_2338 pos = entity.method_24515();
        return EntityUtility.getBlockAt(pos, entity.method_37908());
    }

    public static double getVelocity() {
        return Math.hypot(EntityUtility.mc.field_1724.method_18798().field_1352, EntityUtility.mc.field_1724.method_18798().field_1350);
    }

    public static class_2248 getBlockStandingOnPlayer() {
        if (EntityUtility.mc.field_1724 != null && EntityUtility.mc.field_1687 != null) {
            class_2338 pos = EntityUtility.mc.field_1724.method_24515();
            return EntityUtility.getBlockAt(pos, (class_1937)EntityUtility.mc.field_1687);
        }
        return null;
    }

    public static class_2248 getBlockAt(class_2338 pos, class_1937 world) {
        return world.method_8320(pos).method_26204();
    }

    public static double direction(float rotationYaw, double moveForward, double moveStrafing) {
        if (moveForward < 0.0) {
            rotationYaw += 180.0f;
        }
        float forward = 1.0f;
        if (moveForward < 0.0) {
            forward = -0.5f;
        } else if (moveForward > 0.0) {
            forward = 0.5f;
        }
        if (moveStrafing > 0.0) {
            rotationYaw -= 90.0f * forward;
        }
        if (moveStrafing < 0.0) {
            rotationYaw += 90.0f * forward;
        }
        return Math.toRadians(rotationYaw);
    }

    public static boolean isInGame() {
        return EntityUtility.mc.field_1724 != null && EntityUtility.mc.field_1687 != null;
    }

    public static float getHealth(class_1657 ent) {
        if (ent == null) {
            return 0.0f;
        }
        if (!ServerUtility.isServerForHPFix()) {
            return ent.method_6032() + ent.method_6067();
        }
        class_266 scoreBoard = ent.method_7327().method_1189(class_8646.field_45158);
        if (scoreBoard != null) {
            class_9013 score = ent.method_7327().method_55430((class_9015)ent, scoreBoard);
            String text = class_9013.method_55398((class_9013)score, (class_9022)scoreBoard.method_55380((class_9022)class_9025.field_47566)).getString();
            String digits = text.replaceAll("[^0-9.]", "");
            try {
                return Float.parseFloat(digits);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ent.method_6063();
    }

    public static boolean isHoldingWeapon() {
        if (EntityUtility.mc.field_1724 == null) {
            return false;
        }
        class_1799 heldStack = EntityUtility.mc.field_1724.method_6047();
        class_1792 heldItem = heldStack.method_7909();
        return heldStack.method_7960() ? false : heldItem instanceof class_1829 || heldItem instanceof class_1743 || heldItem instanceof class_1835 || heldItem instanceof class_9362;
    }

    @Generated
    private EntityUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static void setTimer(float timer) {
        EntityUtility.timer = timer;
    }

    @Generated
    public static float getTimer() {
        return timer;
    }
}

